<?php
function start_services_at_ms_and_sc( $argv ) {
    $services_at_sc = array( "crond",
                             "scagentd",
                             "arsenderd",
                             "spcd" ) ;
                             
    $services_at_ms = array( "crond" ) ;
#                             "scmasterd" ) ;
                             
    $result = 0 ;
    try {
    
        ############################################################
        # start services at SC
        ############################################################
        foreach( $services_at_sc as $service ) {
            debug_print( "[Add/Remove Sandbox] Start SC service: $service" ) ;
            $retArray = run_program_at_sc_by_ssh( array(
                'exit_when_error' => 0,
                'program'   => "/sbin/service",
                'arguments' => array(
                    $service,
                    "start" ) ) ) ;

            # 0: no error, 2: already running
            $retValue    = $retArray[ 0 ] ;
            $retMsgArray = $retArray[ 1 ] ;
            if( $retValue != 0 && $retValue != 2 ) {
                throw new Exception(
                    join( " ", $retMsgArray ) ) ;
            }
        }


        ############################################################
        # start services at MS
        ############################################################
        foreach( $services_at_ms as $service ) {
            debug_print( "[Add/Remove Sandbox] start MS service: $service" ) ;
            $retArray = run_program_at_ms( array(
                'exit_when_error' => 0,
                'program'   => 'service',
                'arguments' => array(
                    $service,
                    'start' ) ) ) ;
            
            # 0: no error, 2: already running
            $retValue    = $retArray[ 0 ] ;
            $retMsgArray = $retArray[ 1 ] ;
            if( $retValue != 0 && $retValue != 2 ) {
                throw new Exception(
                    join( " ", $retMsgArray ) ) ;
            }
        }
    }
    
    catch( Exception $e ) {
        debug_print( "Exception caught: " . $e->getMessage() ) ;
        echo 'ErrorMessage: ' . $e->getMessage() ;
        $result = 1 ;
    }
    
    exit( $result ) ;
}
